MULTIPOL <- function(X, B, PHI, method = "fast", output = TRUE) {
  
  
  
  files <- list.files("lib", pattern = "\\.R$", full.names = TRUE)
  lapply(files, source)
 
  Y <- log(X / (1 - X)) #logit
  
  output1 <- reapmll1(Y, B, PHI)
  alpha <- output1$alpha
  Beta <- output1$Beta
  sumBeta <- output1$sumBeta
  varres <- output1$varres
  Mdif <- output1$Mdif
  Mdisc1 <- output1$Mdisc1
  Mdisc <- output1$Mdisc
  Mdisc2 <- output1$Mdisc2
  PROYC <- output1$PROYC
  
  # Nodes
  
  nodes = get_nodes(method)
  
  # scoring
  FAC <- reapmull1con(X, B, output1$alpha, output1$varres, nodes)
  FAC <- as.data.frame(FAC)
  n_factors <- ncol(B)
  
  column_names <- c()
  
  for (i in 1:n_factors) {
    column_names <- c(column_names, 
                      paste("Point estimate", i),
                      paste("  PSD", i),
                      paste("Reliability", i))
  }
  
  # Asignar los nombres de las columnas al dataframe FAC
  colnames(FAC) <- column_names
  
  #colnames(FAC) <- c("Point estimate 1", "Point estimate 2", "  PSDs 1","  PSDs 2", "Reliability 1", "Reliability 2")
  
  # PRINTING
  
  if (output == TRUE){
    
    original_max_print <- getOption("max.print")
    options(max.print = .Machine$integer.max)
    
    cat("\nCALIBRATION\n\n")
    
    cat("Item easiness parameter estimates:\n")
    cat(format(alpha, digits = 4, nsmall = 4), sep = "\n")
    cat("\n\n")
    
    cat("Item Beta parameter estimates:\n")
    cat(apply(Beta, 1, function(row) paste(format(row, digits = 4, nsmall = 4), collapse = "\t")), sep = "\n")
    cat("\n\n")
    
    cat("Overall item discriminations:\n")
    cat(format(sumBeta, digits = 4, nsmall = 4), sep = "\n")
    cat("\n\n")
    
    cat("Multidimensional locations (difficulty):\n")
    cat(format(Mdif, digits = 4, nsmall = 4), sep = "\n")
    cat("\n\n")
    
    cat("Multidimensional slopes:\n")
    Mdisc_tot = as.data.frame(cbind(Mdisc1, Mdisc, Mdisc2))
    colnames(Mdisc_tot) <- c(".25", ".5", ".75")
    print(format(Mdisc_tot, digits = 4, nsmall = 4), row.names = FALSE)
    cat("\n\n")
    
    cat("Orthogonal projections on the factor axes:\n")
    cat(apply(PROYC, 1, function(row) paste(format(row, digits = 4, nsmall = 4), collapse = "\t")), sep = "\n")
    cat("\n\n")
    
    cat("\nSCORES\n\n")
    
    FAC_rounded <- FAC
    
    FAC_rounded[, sapply(FAC_rounded, is.numeric)] <- round(FAC_rounded[, sapply(FAC_rounded, is.numeric)], 3)
    
    print(format(FAC_rounded, digits = 1, nsmall = 3, scientific = FALSE), quote = FALSE)
    cat("\n\n")
    
    cat("Marginal reliability 1: ", mean(as.numeric(FAC[,5])))
    cat("\n\n")
    
    cat("Marginal reliability 2: ", mean(as.numeric(FAC[,6])))
    cat("\n\n")
    
    options(max.print = original_max_print)
  
  }
  
  OUT <- list("Alpha" = alpha, "Beta" = Beta, "Overall_item_discriminations" = sumBeta, "Multidimensional_locations" = Mdif, 
              "Multidimensional_slopes" = Mdisc_tot, "Orthogonal_projections" = PROYC, "Scores", FAC)
  invisible(OUT)
  
}